package gov.va.med.mhv.calendar.service;

import gov.va.med.mhv.calendar.dto.AppointmentReminderDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/")
@Service("appointmentReminderService")
public interface AppointmentReminderService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("getScheduledAppointmentRemindersForDateRange")
	public List<AppointmentReminderDTO> getScheduledAppointmentRemindersForDateRange() throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("getScheduledAppointmentRemindersForDateRange")
	public List<AppointmentReminderDTO> getScheduledAppointmentRemindersForPatient(@PathParam("patientId") Long patientId) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveAppointmentReminder")
	public void saveAppointmentReminder(AppointmentReminderDTO appointmentReminderDto) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteAppointmentReminder/{is}")
	public void deleteAppointmentReminder(@PathParam("Id") Long id) throws MHVException;
}
